<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CGallery extends CPlugin{
	
	var $tplvars; 


	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}
	

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "gallery") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":

					if ($this->tpl_module["settings"]["set_style"] == "onepage") {
						return $this->OnePage();
					}
					

					return $this->Albums();
				break;

				case "album":
					return $this->Album();
				break;

				case "photo":
					return $this->Photo();
				break;

				case "ajax.gallery":
					return $this->AjaxGallery();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"onepage"				=> "onepage.htm",

			"albums"				=> "albums.htm",
			"albums-ajax"			=> "albums-ajax.htm",
			"album"					=> "album.htm",
			"photo"					=> "photo.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Albums() {
		global $base;


		$text = $this->pageTitleBlock();
		$this->module->plugins["seo"]->PageMeta($text);


		if ($this->tpl_module["settings"]["set_style"] == "ajax") {
			$this->tpl_module["settings"]["set_ipp_albums"] = 99999;
			$template = $this->_t("albums-ajax");
		} else {
			$template = $this->_t("albums");
		}
		


		$albums = $this->_GetItemsPage(
			"	{$this->tables['plugin:gallery_cats']} as c,
				{$this->tables['plugin:gallery_cats_lang']} as l
			",
			$this->tpl_module["settings"]["set_ipp_albums"],
			$_GET["page"],
			"
				c.cat_id=l.cat_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_status = 1 AND 
				c.cat_date <= " . time() . " 
			",
			"cat_order ASC"
		);

		$albums["records"] = $this->ProcessAlbums($albums["records"]);

		$this->SetComments($this->tpl_module["settings"]["set_comments"] , array("link" => $this->tpl_module["link"]));

	
		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$albums["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$albums["pages"] , 
						$albums["page"] , 
						array(
							"first"	=> $this->tpl_module["link"],
							"all"	=> $this->tpl_module["link"] . "p{PAGE}",
						),
						$topics["items"]
					),

					"_title"	=> $text["text_block_1_title"] ? $template->blockReplace("MainTitle" , $text) : "",

					"text_header"	=> $text["text_header"],

				),
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);


	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Album() {
		global $base;
		
		$album = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:gallery_cats']} as p , 
				{$this->tables['plugin:gallery_cats_lang']} as l

			WHERE 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				p.module_id = {$this->tpl_module[mod_id]} AND 
				p.cat_id='%d'
			",
			array($_GET["cat_id"])
		);

		if (!is_array($album)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}
			
		$text = $this->pageTitleBlock(array(
			$this->tpl_module["link"]											=> $this->tpl_module["mod_name"],
			$this->tpl_module["link"] . "{$album[cat_url]}-{$album[cat_id]}/"	=> $album["cat_title"]
		));


		$this->module->plugins["seo"]->PageMeta($album);

		$this->SetComments($this->tpl_module["settings"]["set_comments_details"] , array("link" => $this->tpl_module["link"] . $album["cat_url"] .  "-" . $album["cat_id"] . "/"));

		$images = $this->plugins["media"]->GalleryPage(
			$album["cat_id"] , 
			$album["module_id"] , 
			$this->tpl_module["settings"]["set_ipp_photos"],
			$_GET["page"],
			"" , 
			"" , 
			"array",
			array(
				"path"		=> "upload/gallery",
				"tn"		=> $this->tpl_module["settings"]["set_images_height"] ? "tn" : "tn2",
				"display"	=> "player",
			)
		);

		$template = &$this->private->templates["album"];

		if (is_array($images["records"])) {
			foreach ($images["records"] as $key => $val) {
				$images["records"][$key]["title"] = $this->tpl_module["settings"]["set_show_title"] ? $template->blockReplace("Title" , $val )  : "";
				$images["records"][$key]["likes"] = "";
			}			
		}



		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_album"],
				$this->tpl_module["mod_protected"]
			),

			$template->blockREplacE(
				"Main" , 
				array(
					"_title"	=> $this->tpl_module["settings"]["set_album_elements"] == "title" ? $template->blockReplace("MainTitle" , $album) : "",

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$images["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$images["pages"] , 
						$images["page"] , 
						array(
							"first"	=> $this->tpl_module["link"] . $album["cat_url"] .  "-" . $album["cat_id"] . "/",
							"all"	=> $this->tpl_module["link"] . $album["cat_url"] .  "-" . $album["cat_id"] . "/p{PAGE}",
						),
						$images["items"]
					),

					"social_links" => $this->plugins["socialmedia"] ? $this->plugins["socialmedia"]->Share($this->tpl_module["link"] . $album["cat_url"] .  "-" . $album["cat_id"] . "/") : ""

				),
				$album,
				$this->tpl_module["settings"],
				$this->tpl_module
			)
		);


	}


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessAlbums($items) {

		if (is_array($items)) {

			$elements = explode("," , $this->tpl_module["settings"]["set_albums_elements"]);

			foreach ($items as $key => $val) {

				$items[$key]["script"] = $this->plugins["modules"]->scriptLink("ajax.gallery.json" , array("module_id" => $this->tpl_module["mod_id"] , "aid" => $val["cat_id"]));
				$items[$key]["link"] = $this->tpl_module["link"] . $val["cat_url"] .  "-" . $val["cat_id"] . "/";
				$items[$key]["dl_butt"] =  "";
				
				$items[$key]["image"] = $this->tpl_module["settings"]["set_height"] ? "upload/gallery/albums/tn_{$val[cat_id]}.jpg" : "upload/gallery/albums/{$val[cat_id]}.jpg";				

				$items[$key]["_title"] = $items[$key]["_date"] = $items[$key]["_brief"] = $items[$key]["_images"] = "";

				if (in_array("title" , $elements)) {
					$items[$key]["_title"] = $this->_t("albums")->blockreplace(
						"Title",
						$val
					);
				} 				


				if ($val["cat_brief"]) {
					$val["cat_brief"] = nl2br($val["cat_brief"]);

					$items[$key]["_brief"] = $this->_t("albums")->blockreplace(
						"Brief",
						$val
					);
				} 				

				if (in_array("date", $elements )) {

					$items[$key]["_date"] = $this->_t("albums")->blockReplace(
						"Date" ,
						array(
							"date" => Cdate::ToStr($this->tpl_module["settings"]["set_date_album"] , $val["cat_date"])
						)
					);
				} 


				if (in_array("images", $elements )) {

					$items[$key]["_images"] = $this->_t("albums")->blockReplace(
						"Images" ,
						array(
							"images" => $this->db->RowCount(
								$this->tables["plugin:media"],
								"where module_id={$this->tpl_module[mod_id]} AND item_parent={$val[cat_id]}"
							)
						)
					);
				} 

			}
			
		}
		

		return $items;
	}

	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function OnePage() {
		global $base;

		//read all categories
		$cats = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:gallery_cats']} as c,
				{$this->tables['plugin:gallery_cats_lang']} as l
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_status = 1 AND c.cat_date <= " . time() . " 
			ORDER BY  
				cat_order ASC 
			"
		);

		if (is_array($cats)) {
			foreach ($cats as $key => $val) {
				$cid[] = $val["cat_id"];
			}			

			$items = $this->plugins["media"]->Gallery(
				$cid , 
				$this->tpl_module["mod_id"] , 
				"",
				"",
				"array",
				array(
					"path"	=> "upload/gallery",
					"tn"	=> $this->tpl_module["settings"]["set_images_height"] ? "tn" : "tn2",
					"display"	=> "player",
				)
			);

		}

		$template = &$this->private->templates["onepage"];

		if (is_array($_items)) {
			foreach ($items as $key => $val) {
				$items[$key] = $this->ProcessImage($val);

				$items[$key]["title"] = $this->tpl_module["settings"]["set_show_title"] ? $template->blockReplace("Title" , $val )  : "";
			}			
		}
		

		$text = $this->pageTitleBlock();
		$this->module->plugins["seo"]->PageMeta($text);

		$this->SetComments($this->tpl_module["settings"]["set_comments"] , array("link" => $this->tpl_module["link"]));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"cats"	=> count($cats) > 1 ? $base->html->Table(
						$template, 
						"Cats" , 
						$cats
					) : "",

					"items"	=> $base->html->Table(
						$template, 
						"Photos" , 
						$items
					),

					"_title"	=> $text["text_block_1_title"] ? $template->blockReplace("MainTitle" , $text) : "",


				),
				$text,	
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
					

	}

	


	function GetMenuButton($module) { 

		if ($module["settings"]["set_style"] == "onepage") {
			return parent::GetMenuButton($module);
		}


		switch ($module["settings"]["set_menu_style"]) {
			default:
				return parent::GetMenuButton($module);
			break;

			case "1":
				$items = $this->db->QFetchRowArray(
					"SELECT * " . 
					"FROM 
						{$this->tables['plugin:gallery_cats']} as i,
						{$this->tables['plugin:gallery_cats_lang']} as il
					WHERE 				
						i.cat_id = il.cat_id AND 
						il.lang_id={$module[lang_id]} AND 
						i.module_id={$module[mod_id]} AND 
						cat_status = 1 AND 
						cat_date < %d

					ORDER BY  cat_order ASC",
					array(
						time()
					)
				);


				if (is_array($items)) {
					foreach ($items as $key => $val) {
						$sub[] = array(
							"title"		=> $val["cat_title"],
							"link"		=> $module["link"] . $val["cat_url"] . "-" . $val["cat_id"] . "/ ",
							"selected"	=> ($module["mod_id"] == $val["module_id"] ) && ( $val["cat_id"] == $_GET["cat_id"]) ? true : false,
							"target"	=> "",

							"html"		=> "",
							"sub"		=> "",

						);
					}
				
				}

				return parent::GetMenuButton(
					$module , 
					array( 

						"html"	=> $this->plugins["menus"]->dropDownHTML(								
							array(
								"size"		=> $module["settings"]["set_menu_cols"],
								"id"		=> $module["mod_id"],
								"bg"		=> $module["settings"]["set_menu_bg"],
								"title"		=> $module["mod_name"],
							),
							$sub
						)
					)
				);
			
			break;

		}				
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ajaxGallery() {

		$album = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:gallery_cats']} as p , 
				{$this->tables['plugin:gallery_cats_lang']} as l

			WHERE 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				p.module_id = {$this->tpl_module[mod_id]} AND 
				p.cat_id='%d'
			",
			array($_GET["aid"])
		);

		if (is_Array($album)) {
			$images = $this->plugins["media"]->Gallery(
				$album["cat_id"] , 
				$album["module_id"] , 
				"" , 
				"" , 
				"array",
				array(
					"path"		=> "upload/gallery",
					"tn"		=> $this->tpl_module["settings"]["set_images_height"] ? "tn" : "tn2",
					"display"	=> "player",
				)
			);

			if (is_array($images)) {
				foreach ($images as $key => $val) {

					if (in_array($val["type"] , array(1,2,3,4,7))) {
						$img[] = array(
							"src"		=> $val["source"],
							"thumb"		=> $val["tn"],
							"subHtml"	=> $val["title"],
						);
					}
					
				}
				
			}
			
		}
		

		return $this->plugins["common"]->Json($img);


	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetMaps($module , $lang) {

		if ($module["mod_id"]) {
			return array($module["mod_id"] => true);
		} else {
			return array($module["module_code"] => true);
		}
		
	}


	function SitemapGetLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);


		//multipage then build the subalbums links
		if (!in_array($module["settings"]["set_style"] , array("onepage" , "ajax"))) {

			$items = $this->db->QFetchRowArray(
				"SELECT 
					cat_url , c.cat_id 
				FROM 
					{$this->tables['plugin:gallery_cats']} as c,
					{$this->tables['plugin:gallery_cats_lang']} as l
				WHERE
					c.cat_id=l.cat_id AND 
					l.lang_id={$module[lang_id]} AND 
					c.module_id={$module[mod_id]} AND 
					c.cat_status = 1 AND 
					c.cat_date <= " . time() . " 
				"
			);
			
			if (is_array($items)) {
				foreach ($items as $key => $val) {
					$links[] = array(
						"url" => $module["link"] . $val["cat_url"] .  "-" . $val["cat_id"] . "/",
					);
				}
				
			}
		}

	}

	
}

?>